#!/bin/sh

#only \n
IFS=$'\n'

#define
FontsName=fonts
VersionName=10.8.1

DMFonts=server
User_check()
{
NowUser=`echo $HOME | sed -e s'#/home/##g'`
if [ "${USER}" = "$NowUser" ]
 then
 :
else
    echo "#################################################"
    echo "                      Error                      "
    echo "        Please run as the installation user.     "
    echo "#################################################"
    exit 1
fi
}

Enterprise_Version_Check()
{
  ProductSetupFile="$HOME/.ESRI.properties.`uname -n`.$VersionName"
  if [ -e $ProductSetupFile ] && [ -r $ProductSetupFile ]; then
    . $ProductSetupFile 2> /dev/null
    if [ -e $Z_ArcGISServer_INSTALL_DIR ] && [ $VersionName = $Z_REAL_VERSION ] ;then
        installver=$Z_REAL_VERSION
        installdir=$Z_ArcGISServer_INSTALL_DIR
    else
        echo "#################################################"
        echo "                    Error                        "
        echo "    ArcGIS Server $VersionName is not Install.   "
        echo "    Please run this file after installing.       "
        echo "               End processing.                   "
        echo "#################################################"
        exit 1
    fi
  else
    echo "#################################################"
    echo "                     Error                       "
    echo " $ProductSetupFile                               "
    echo "       Does not exist or can't read the file.    " 
    echo "             Please confirm the file.            "
    echo "                  End processing.                "
    echo "#################################################"
    exit 1
  fi
}

move_file()
{
  motoDir=$1
  sakiDir=$2
  
  
  # check DMFonts directory 
  if [ ! -d $motoDir ]; then
    echo "#################################################"
    echo "                     Error                       "
    echo "[$motoDir] is Not Found in DMFonts.              "
    echo "          Please respons EsriJapan.              "
    echo "     URL:https://www.esrij.com/form/inquiry/     "
    echo "#################################################"
    exit 1
  fi
  
 # check directory in ArcGIS Server
  if [ ! -d $sakiDir ]; then
    echo "#################################################"
    echo "                     Error                       "
    echo "[$sakiDir] is Not Found.                         "
    echo "       Does not exist or can't read the file.    "
    echo "             Please confirm the file.            "
    echo "                  End processing.                "
    echo "#################################################"
    exit 1
  fi
  
  copy_files $motoDir $sakiDir
}

copy_files()
{
  cpmotoDir=$1
  cpsakiDir=$2
  
  cd $cpmotoDir
  
  for fName in `find .  -maxdepth 1 -type f`
  do
    efName=`echo $fName | sed -e s'#./##g'`
    sakiFile=$cpsakiDir/$efName

    if [ -f $sakiFile ]; then
      echo "[$sakiFile] already exists"
      echo "Create overwrite and backup file."
      cp -b $fName $sakiFile
    fi

    cp -f $fName $sakiFile

     echo "Copy [$efName] to [$cpsakiDir]"
     echo

    if [ ! -f $sakiFile ]; then
      echo "#################################################"
      echo "                     Error                       "
      echo "   Copy failed. [$sakiFile] is Not Found.        "
      echo "             Please confirm the file.            "
      echo "                  End processing.                "
      echo "#################################################"
         exit 1
    fi
  done
}

User_check
Enterprise_Version_Check

echo "#################################################"
echo "##             START Japan Package             ##"
echo "#################################################"
echo "        Enetprise Version  $Z_REAL_VERSION       "
echo "             Target Server Foder                 "
echo "         $Z_ArcGISServer_INSTALL_DIR             "
echo "#################################################"

#get file name(motodir)
SCRIPT_DIR=$(cd $(dirname $0); pwd)

sakiFonts=$installdir/$FontsName


motoFonts=$SCRIPT_DIR/$DMFonts/$FontsName

# move_file 
move_file $motoFonts $sakiFonts

echo "#################################################"
echo "##           Install Successfully!!            ##"
echo "#################################################"

exit 0

