/*
 * Decompiled with CFR 0.152.
 */
package com.esri.geoevent.processor.motioncalculator;

import com.esri.ges.core.property.LabeledValue;
import com.esri.ges.core.property.PropertyDefinition;
import com.esri.ges.core.property.PropertyType;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.processor.GeoEventProcessorDefinitionBase;
import java.util.ArrayList;

public class MotionCalculatorDefinition
extends GeoEventProcessorDefinitionBase {
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(MotionCalculatorDefinition.class);

    public MotionCalculatorDefinition() {
        try {
            ArrayList<LabeledValue> distanceUnitsAllowedValues = new ArrayList<LabeledValue>();
            distanceUnitsAllowedValues.add(new LabeledValue("Kilometers", (Object)"Kilometers"));
            distanceUnitsAllowedValues.add(new LabeledValue("Miles", (Object)"Miles"));
            distanceUnitsAllowedValues.add(new LabeledValue("Nautical Miles", (Object)"Nautical Miles"));
            this.propertyDefinitions.put("distanceUnit", new PropertyDefinition("distanceUnit", PropertyType.String, (Object)"Kilometers", "Distance Unit", "Distance unit to be used", Boolean.valueOf(false), Boolean.valueOf(false), distanceUnitsAllowedValues));
            ArrayList<LabeledValue> geometryTypeAllowedValues = new ArrayList<LabeledValue>();
            geometryTypeAllowedValues.add(new LabeledValue("Point", (Object)"Point"));
            geometryTypeAllowedValues.add(new LabeledValue("Line", (Object)"Line"));
            this.propertyDefinitions.put("geometryType", new PropertyDefinition("geometryType", PropertyType.String, (Object)"Kilometers", "Geometry Type", "The resulting Geometry Type", Boolean.valueOf(false), Boolean.valueOf(false), geometryTypeAllowedValues));
            ArrayList<LabeledValue> notificationModeAllowedValues = new ArrayList<LabeledValue>();
            notificationModeAllowedValues.add(new LabeledValue("OnChange", (Object)"OnChange"));
            notificationModeAllowedValues.add(new LabeledValue("Continuous", (Object)"Continuous"));
            this.propertyDefinitions.put("notificationMode", new PropertyDefinition("notificationMode", PropertyType.String, (Object)"OnChange", "Count Notification Mode", "Count Notification Mode", Boolean.valueOf(true), Boolean.valueOf(false), notificationModeAllowedValues));
            this.propertyDefinitions.put("reportInterval", new PropertyDefinition("reportInterval", PropertyType.Long, (Object)10, "Report Interval (seconds)", "Report Interval (seconds)", "notificationMode=Continuous", Boolean.valueOf(false), Boolean.valueOf(false)));
            this.propertyDefinitions.put("autoResetCache", new PropertyDefinition("autoResetCache", PropertyType.Boolean, (Object)false, "Automatic Reset Cache", "Auto Reset Cache", Boolean.valueOf(true), Boolean.valueOf(false)));
            this.propertyDefinitions.put("resetTime", new PropertyDefinition("resetTime", PropertyType.String, (Object)"00:00:00", "Reset Cache at", "Reset Cache time", "autoResetCache=true", Boolean.valueOf(false), Boolean.valueOf(false)));
            this.propertyDefinitions.put("clearCache", new PropertyDefinition("clearCache", PropertyType.Boolean, (Object)true, "Clear in-memory Cache", "Clear in-memory Cache", "autoResetCache=true", Boolean.valueOf(false), Boolean.valueOf(false)));
            this.propertyDefinitions.put("predictiveTimespan", new PropertyDefinition("predictiveTimespan", PropertyType.Integer, (Object)10, "Predictive Timespan (seconds)", "Timespan in seconds to calculate the next position.", Boolean.valueOf(false), Boolean.valueOf(false)));
            ArrayList<LabeledValue> predictiveGeometryTypeAllowedValues = new ArrayList<LabeledValue>();
            predictiveGeometryTypeAllowedValues.add(new LabeledValue("Point", (Object)"Point"));
            predictiveGeometryTypeAllowedValues.add(new LabeledValue("Line", (Object)"Line"));
            this.propertyDefinitions.put("predictiveGeometryType", new PropertyDefinition("predictiveGeometryType", PropertyType.String, (Object)"Kilometers", "Geometry Type", "The resulting Geometry Type", Boolean.valueOf(false), Boolean.valueOf(false), predictiveGeometryTypeAllowedValues));
            this.propertyDefinitions.put("newGeoEventDefinitionName", new PropertyDefinition("newGeoEventDefinitionName", PropertyType.String, (Object)"MotionCalculatorDef", "Resulting GeoEvent Definition Name", "Resulting GeoEvent Definition Name", Boolean.valueOf(false), Boolean.valueOf(false)));
        }
        catch (Exception error) {
            LOGGER.error("INIT_ERROR", new Object[]{error.getMessage()});
            LOGGER.info(error.getMessage(), (Throwable)error);
        }
    }

    public String getName() {
        return "MotionCalculator";
    }

    public String getDomain() {
        return "com.esri.geoevent.processor";
    }

    public String getVersion() {
        return "10.6.0";
    }

    public String getLabel() {
        return "${com.esri.geoevent.processor.motion-calculator-processor.PROCESSOR_LABEL}";
    }

    public String getDescription() {
        return "${com.esri.geoevent.processor.motion-calculator-processor.PROCESSOR_DESC}";
    }
}

