/*
 * Decompiled with CFR 0.152.
 */
package com.esri.geoevent.processor.motioncalculator;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.MapGeometry;
import com.esri.core.geometry.Point;
import com.esri.core.geometry.Polyline;
import com.esri.core.geometry.SpatialReference;
import com.esri.geoevent.processor.motioncalculator.MotionCalculatorNotificationMode;
import com.esri.ges.core.component.ComponentException;
import com.esri.ges.core.geoevent.DefaultFieldDefinition;
import com.esri.ges.core.geoevent.FieldDefinition;
import com.esri.ges.core.geoevent.FieldType;
import com.esri.ges.core.geoevent.GeoEvent;
import com.esri.ges.core.geoevent.GeoEventDefinition;
import com.esri.ges.core.geoevent.GeoEventPropertyName;
import com.esri.ges.core.validation.ValidationException;
import com.esri.ges.framework.i18n.BundleLogger;
import com.esri.ges.framework.i18n.BundleLoggerFactory;
import com.esri.ges.manager.geoeventdefinition.GeoEventDefinitionManager;
import com.esri.ges.manager.geoeventdefinition.GeoEventDefinitionManagerException;
import com.esri.ges.messaging.EventDestination;
import com.esri.ges.messaging.EventUpdatable;
import com.esri.ges.messaging.GeoEventCreator;
import com.esri.ges.messaging.GeoEventProducer;
import com.esri.ges.messaging.Messaging;
import com.esri.ges.messaging.MessagingException;
import com.esri.ges.processor.GeoEventProcessorBase;
import com.esri.ges.processor.GeoEventProcessorDefinition;
import com.esri.ges.util.Converter;
import com.esri.ges.util.Validator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public class MotionCalculator
extends GeoEventProcessorBase
implements GeoEventProducer,
EventUpdatable {
    private static final BundleLogger LOGGER = BundleLoggerFactory.getLogger(MotionCalculator.class);
    private MotionCalculatorNotificationMode notificationMode;
    private long reportInterval;
    private final Map<String, MotionElements> motionElementsCache = new ConcurrentHashMap<String, MotionElements>();
    private Messaging messaging;
    private GeoEventCreator geoEventCreator;
    private GeoEventProducer geoEventProducer;
    private String distanceUnit;
    private String geometryType;
    private String predictiveGeometryType;
    private Integer predictiveTimespan;
    private Date resetTime;
    private boolean autoResetCache;
    private Timer clearCacheTimer;
    private boolean clearCache;
    private boolean isReporting = false;
    private GeoEventDefinitionManager geoEventDefinitionManager;
    private Map<String, String> edMapper = new ConcurrentHashMap<String, String>();
    private String newGeoEventDefinitionName;
    final Object lock1 = new Object();

    protected MotionCalculator(GeoEventProcessorDefinition definition) throws ComponentException {
        super(definition);
    }

    public void afterPropertiesSet() {
        this.newGeoEventDefinitionName = this.getProperty("newGeoEventDefinitionName").getValueAsString();
        this.distanceUnit = this.getProperty("distanceUnit").getValueAsString();
        this.geometryType = this.getProperty("geometryType").getValueAsString();
        this.notificationMode = (MotionCalculatorNotificationMode)Validator.valueOfIgnoreCase(MotionCalculatorNotificationMode.class, (String)this.getProperty("notificationMode").getValueAsString(), (Enum)MotionCalculatorNotificationMode.OnChange);
        this.reportInterval = Converter.convertToInteger((String)this.getProperty("reportInterval").getValueAsString(), (Integer)10) * 1000;
        this.autoResetCache = Converter.convertToBoolean((Object)this.getProperty("autoResetCache").getValueAsString());
        this.clearCache = Converter.convertToBoolean((Object)this.getProperty("clearCache").getValueAsString());
        this.predictiveGeometryType = this.getProperty("predictiveGeometryType").getValueAsString();
        this.predictiveTimespan = Converter.convertToInteger((String)this.getProperty("predictiveTimespan").getValueAsString(), (Integer)10);
        String[] resetTimeStr = this.getProperty("resetTime").getValueAsString().split(":");
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, Integer.parseInt(resetTimeStr[0]));
        calendar.set(12, Integer.parseInt(resetTimeStr[1]));
        calendar.set(13, Integer.parseInt(resetTimeStr[2]));
        this.resetTime = calendar.getTime();
    }

    public void setId(String id) {
        super.setId(id);
        this.geoEventProducer = this.messaging.createGeoEventProducer(new EventDestination(id + ":event"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GeoEvent process(GeoEvent geoevent) throws Exception {
        MotionElements motionEle;
        String trackId = geoevent.getTrackId();
        if (!this.motionElementsCache.containsKey(trackId)) {
            motionEle = new MotionElements(geoevent);
        } else {
            motionEle = this.motionElementsCache.get(trackId);
            boolean correctTemporalOrder = motionEle.setGeoEvent(geoevent);
            if (correctTemporalOrder) {
                motionEle.calculateAndSendReport();
            } else {
                LOGGER.error("Wrong temporal order detected: " + geoevent.toString());
            }
        }
        Object object = this.lock1;
        synchronized (object) {
            this.motionElementsCache.put(trackId, motionEle);
        }
        return null;
    }

    public List<EventDestination> getEventDestinations() {
        return this.geoEventProducer != null ? Arrays.asList(this.geoEventProducer.getEventDestination()) : new ArrayList<EventDestination>();
    }

    public void validate() throws ValidationException {
        super.validate();
        ArrayList<String> errors = new ArrayList<String>();
        if (this.reportInterval <= 0L) {
            errors.add(LOGGER.translate("VALIDATION_INVALID_REPORT_INTERVAL", new Object[]{this.definition.getName()}));
        }
        if (errors.size() > 0) {
            StringBuffer sb = new StringBuffer();
            for (String message : errors) {
                sb.append(message).append("\n");
            }
            throw new ValidationException(LOGGER.translate("VALIDATION_ERROR", new Object[]{((Object)((Object)this)).getClass().getName(), sb.toString()}));
        }
    }

    public void onServiceStart() {
        if (this.autoResetCache || this.clearCache) {
            if (this.clearCacheTimer == null) {
                Calendar calendar1 = Calendar.getInstance();
                calendar1.setTime(this.resetTime);
                Date time1 = calendar1.getTime();
                this.clearCacheTimer = new Timer();
                Long dayInMilliSeconds = 86400000L;
                this.clearCacheTimer.scheduleAtFixedRate((TimerTask)new ClearCacheTask(), time1, (long)dayInMilliSeconds);
            }
            this.motionElementsCache.clear();
        }
        this.isReporting = true;
        ReportGenerator reportGen = new ReportGenerator(this.reportInterval);
        Thread thread = new Thread(reportGen);
        thread.setName("MotionCalculator Report Generator");
        thread.start();
    }

    public void onServiceStop() {
        if (this.clearCacheTimer != null) {
            this.clearCacheTimer.cancel();
        }
        this.isReporting = false;
    }

    public void shutdown() {
        super.shutdown();
        if (this.clearCacheTimer != null) {
            this.clearCacheTimer.cancel();
        }
        this.clearGeoEventDefinitionMapper();
    }

    public EventDestination getEventDestination() {
        return this.geoEventProducer != null ? this.geoEventProducer.getEventDestination() : null;
    }

    public void send(GeoEvent geoEvent) throws MessagingException {
        if (this.geoEventProducer != null && geoEvent != null) {
            this.geoEventProducer.send(geoEvent);
        }
    }

    public void setMessaging(Messaging messaging) {
        this.messaging = messaging;
        this.geoEventCreator = messaging.createGeoEventCreator();
    }

    public void setGeoEventDefinitionManager(GeoEventDefinitionManager geoEventDefinitionManager) {
        this.geoEventDefinitionManager = geoEventDefinitionManager;
    }

    public void disconnect() {
        if (this.geoEventProducer != null) {
            this.geoEventProducer.disconnect();
        }
    }

    public String getStatusDetails() {
        return this.geoEventProducer != null ? this.geoEventProducer.getStatusDetails() : "";
    }

    public void init() throws MessagingException {
        this.afterPropertiesSet();
    }

    public boolean isConnected() {
        return this.geoEventProducer != null ? this.geoEventProducer.isConnected() : false;
    }

    public void setup() throws MessagingException {
    }

    public void update(Observable o, Object arg) {
    }

    private List<FieldDefinition> createFieldDefinitionList() {
        ArrayList<FieldDefinition> fdsMC = new ArrayList<FieldDefinition>();
        try {
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("distance", FieldType.Double, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("height", FieldType.Double, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("timespan", FieldType.Double, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("speed", FieldType.Double, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("heading", FieldType.Double, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("slope", FieldType.Double, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("minTimespan", FieldType.Double, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("maxTimespan", FieldType.Double, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("avgTimespan", FieldType.Double, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("minDistance", FieldType.Double, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("maxDistance", FieldType.Double, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("avgDistance", FieldType.Double, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("minHeight", FieldType.Double, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("maxHeight", FieldType.Double, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("avgHeight", FieldType.Double, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("minSpeed", FieldType.Double, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("maxSpeed", FieldType.Double, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("avgSpeed", FieldType.Double, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("minAcceleration", FieldType.Double, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("maxAcceleration", FieldType.Double, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("avgAcceleration", FieldType.Double, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("minSlope", FieldType.Double, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("maxSlope", FieldType.Double, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("avgSlope", FieldType.Double, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("cumulativeDistance", FieldType.Double, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("cumulativeHeight", FieldType.Double, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("cumulativeTime", FieldType.Double, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("calculatedAt", FieldType.Date, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("predictiveTime", FieldType.Date, new String[0]));
            fdsMC.add((FieldDefinition)new DefaultFieldDefinition("predictivePosition", FieldType.Geometry, new String[0]));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fdsMC;
    }

    private Object[] createMotionGeoEventFields(String trackId, MotionElements motionElements) {
        ArrayList<Comparable<Double>> motionFieldList = new ArrayList<Comparable<Double>>();
        motionFieldList.add(motionElements.getDistance());
        motionFieldList.add(motionElements.getHeight());
        motionFieldList.add(motionElements.getTimespanSeconds());
        motionFieldList.add(motionElements.getSpeed());
        motionFieldList.add(motionElements.getHeadingDegrees());
        motionFieldList.add(motionElements.getSlope());
        motionFieldList.add(motionElements.getMinTime());
        motionFieldList.add(motionElements.getMaxTime());
        motionFieldList.add(motionElements.getAvgTime());
        motionFieldList.add(motionElements.getMinDistance());
        motionFieldList.add(motionElements.getMaxDistance());
        motionFieldList.add(motionElements.getAvgDistance());
        motionFieldList.add(motionElements.getMinHeight());
        motionFieldList.add(motionElements.getMaxHeight());
        motionFieldList.add(motionElements.getAvgHeight());
        motionFieldList.add(motionElements.getMinSpeed());
        motionFieldList.add(motionElements.getMaxSpeed());
        motionFieldList.add(motionElements.getAvgSpeed());
        motionFieldList.add(motionElements.getMinAcceleration());
        motionFieldList.add(motionElements.getMaxAcceleration());
        motionFieldList.add(motionElements.getAvgAcceleration());
        motionFieldList.add(motionElements.getMinSlope());
        motionFieldList.add(motionElements.getMaxSlope());
        motionFieldList.add(motionElements.getAvgSlope());
        motionFieldList.add(motionElements.getCumulativeDistance());
        motionFieldList.add(motionElements.getCumulativeHeight());
        motionFieldList.add(motionElements.getCumulativeTime());
        motionFieldList.add(motionElements.getTimestamp());
        motionFieldList.add(motionElements.getPredictiveTime());
        motionFieldList.add((Comparable<Double>)motionElements.getPredictiveGeometry());
        return motionFieldList.toArray();
    }

    private synchronized GeoEventDefinition lookupAndCreateEnrichedDefinition(GeoEventDefinition edIn) throws Exception {
        GeoEventDefinition edOut;
        if (edIn == null) {
            LOGGER.debug("edIn is null");
            return null;
        }
        GeoEventDefinition geoEventDefinition = edOut = this.edMapper.containsKey(edIn.getGuid()) ? this.geoEventDefinitionManager.getGeoEventDefinition(this.edMapper.get(edIn.getGuid())) : null;
        if (edOut == null) {
            edOut = edIn.augment(this.createFieldDefinitionList());
            edOut.setName(this.newGeoEventDefinitionName);
            edOut.setOwner(this.getId());
            this.geoEventDefinitionManager.addTemporaryGeoEventDefinition(edOut, this.newGeoEventDefinitionName.isEmpty());
            this.edMapper.put(edIn.getGuid(), edOut.getGuid());
        }
        return edOut;
    }

    private synchronized void clearGeoEventDefinitionMapper() {
        if (!this.edMapper.isEmpty()) {
            for (String guid : this.edMapper.values()) {
                try {
                    this.geoEventDefinitionManager.deleteGeoEventDefinition(guid);
                }
                catch (GeoEventDefinitionManagerException geoEventDefinitionManagerException) {}
            }
            this.edMapper.clear();
        }
    }

    private static Double lawOfCosineDistance(Double lon1, Double lat1, Double lon2, Double lat2) {
        Double R = 6356.7523142;
        Double radLon1 = MotionCalculator.toRadians(lon1);
        Double radLat1 = MotionCalculator.toRadians(lat1);
        Double radLon2 = MotionCalculator.toRadians(lon2);
        Double radLat2 = MotionCalculator.toRadians(lat2);
        return Math.acos(Math.sin(radLat1) * Math.sin(radLat2) + Math.cos(radLat1) * Math.cos(radLat2) * Math.cos(radLon2 - radLon1)) * R;
    }

    private static Double halversineDistance(Double lon1, Double lat1, Double lon2, Double lat2) {
        Double R = 6356.7523142;
        Double latDistance = MotionCalculator.toRadians(lat2 - lat1);
        Double lonDistance = MotionCalculator.toRadians(lon2 - lon1);
        Double a = Math.sin(latDistance / 2.0) * Math.sin(latDistance / 2.0) + Math.cos(MotionCalculator.toRadians(lat1)) * Math.cos(MotionCalculator.toRadians(lat2)) * Math.sin(lonDistance / 2.0) * Math.sin(lonDistance / 2.0);
        Double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        Double distance = R * c;
        return distance;
    }

    private static Double heading(Double lon1, Double lat1, Double lon2, Double lat2) {
        Double radLon1 = MotionCalculator.toRadians(lon1);
        Double radLat1 = MotionCalculator.toRadians(lat1);
        Double radLon2 = MotionCalculator.toRadians(lon2);
        Double radLat2 = MotionCalculator.toRadians(lat2);
        Double y = Math.sin(radLon2 - radLon1) * Math.cos(radLat2);
        Double x = Math.cos(radLat1) * Math.sin(radLat2) - Math.sin(radLat1) * Math.cos(radLat2) * Math.cos(radLon2 - radLon1);
        Double headingDegrees = MotionCalculator.toDegrees(Math.atan2(y, x) % (Math.PI * 2));
        return headingDegrees;
    }

    private static Double toRadians(Double value) {
        return value * Math.PI / 180.0;
    }

    private static Double toDegrees(Double value) {
        return value * 180.0 / Math.PI;
    }

    class ReportGenerator
    implements Runnable {
        private Long reportInterval = 5000L;

        public ReportGenerator(Long reportInterval) {
            this.reportInterval = reportInterval;
        }

        @Override
        public void run() {
            while (MotionCalculator.this.isReporting) {
                try {
                    Thread.sleep(this.reportInterval);
                    if (MotionCalculator.this.notificationMode != MotionCalculatorNotificationMode.Continuous) continue;
                    for (String trackId : MotionCalculator.this.motionElementsCache.keySet()) {
                        MotionElements motionEle = (MotionElements)MotionCalculator.this.motionElementsCache.get(trackId);
                        GeoEvent outGeoEvent = null;
                        try {
                            outGeoEvent = motionEle.createMotionGeoEvent();
                            if (outGeoEvent == null) {
                                LOGGER.debug("outGeoEvent is null");
                                continue;
                            }
                            LOGGER.debug("send");
                            LOGGER.debug(outGeoEvent.toString());
                            MotionCalculator.this.send(outGeoEvent);
                        }
                        catch (MessagingException error) {
                            LOGGER.error("SEND_ERROR", new Object[]{outGeoEvent, error.getMessage()});
                            LOGGER.info(error.getMessage(), (Throwable)error);
                        }
                    }
                }
                catch (InterruptedException error) {
                    LOGGER.error(error.getMessage(), (Throwable)error);
                }
            }
        }
    }

    class ClearCacheTask
    extends TimerTask {
        ClearCacheTask() {
        }

        @Override
        public void run() {
            if (MotionCalculator.this.autoResetCache && MotionCalculator.this.clearCache) {
                MotionCalculator.this.motionElementsCache.clear();
            }
        }
    }

    class MotionElements {
        private GeoEvent previousGeoEvent;
        private GeoEvent currentGeoEvent;
        private String id;
        private Geometry lineGeometry;
        private Double distance = 0.0;
        private Double height = 0.0;
        private Double slope = 0.0;
        private Double timespanSeconds = 0.0;
        private Double speed = 0.0;
        private Double acceleration = 0.0;
        private Double headingDegrees = 0.0;
        private Double cumulativeDistance = 0.0;
        private Double cumulativeHeight = 0.0;
        private Double cumulativeTimeSeconds = 0.0;
        private Double minDistance = Double.MAX_VALUE;
        private Double maxDistance = Double.MIN_VALUE;
        private Double avgDistance = 0.0;
        private Double minHeight = Double.MAX_VALUE;
        private Double maxHeight = Double.MIN_VALUE;
        private Double avgHeight = 0.0;
        private Double minSpeed = Double.MAX_VALUE;
        private Double maxSpeed = Double.MIN_VALUE;
        private Double avgSpeed = 0.0;
        private Double minAcceleration = Double.MAX_VALUE;
        private Double maxAcceleration = Double.MIN_VALUE;
        private Double avgAcceleration = 0.0;
        private Double minTimespan = Double.MAX_VALUE;
        private Double maxTimespan = Double.MIN_VALUE;
        private Double avgTimespan = 0.0;
        private Double minSlope = Double.MAX_VALUE;
        private Double maxSlope = Double.MIN_VALUE;
        private Double avgSlope = 0.0;
        private Long count = 0L;
        private Date predictiveTime;

        public MotionElements(GeoEvent geoevent) {
            this.currentGeoEvent = geoevent;
            LOGGER.debug("MotionElements");
            LOGGER.debug(geoevent.toString());
        }

        public boolean setGeoEvent(GeoEvent geoevent) {
            LOGGER.debug("setGeoEvent");
            LOGGER.debug(geoevent.toString());
            Long timespanMilliSecs = 0L;
            timespanMilliSecs = geoevent.getStartTime().getTime() - this.getCurrentGeoEvent().getStartTime().getTime();
            if (timespanMilliSecs < 0L) {
                return false;
            }
            this.previousGeoEvent = this.getCurrentGeoEvent();
            this.currentGeoEvent = geoevent;
            return true;
        }

        public Long getCount() {
            return this.count;
        }

        public Double getCumulativeDistance() {
            return this.cumulativeDistance;
        }

        public Double getCumulativeHeight() {
            return this.cumulativeHeight;
        }

        public Double getCumulativeTime() {
            return this.cumulativeTimeSeconds;
        }

        public Geometry getGeometry() {
            if (MotionCalculator.this.geometryType.equals("Point")) {
                return this.getCurrentGeoEvent().getGeometry().getGeometry();
            }
            return this.lineGeometry;
        }

        public void computeTimespan() {
            Long timespanMilliSecs = 0L;
            timespanMilliSecs = this.getCurrentGeoEvent().getStartTime().getTime() - this.getPreviousGeoEvent().getStartTime().getTime();
            this.timespanSeconds = (double)timespanMilliSecs.longValue() / 1000.0;
            if (this.timespanSeconds == 0.0) {
                this.timespanSeconds = 1.0E-10;
            }
            if (this.minTimespan > this.timespanSeconds) {
                this.minTimespan = this.timespanSeconds;
            }
            if (this.maxTimespan < this.timespanSeconds) {
                this.maxTimespan = this.timespanSeconds;
            }
            this.cumulativeTimeSeconds = this.cumulativeTimeSeconds + this.timespanSeconds;
            this.avgTimespan = this.count > 0L ? Double.valueOf(this.cumulativeTimeSeconds / (double)this.count.longValue()) : this.cumulativeTimeSeconds;
        }

        public void calculateAndSendReport() {
            MotionElements motionElements;
            if (this.previousGeoEvent == null) {
                return;
            }
            Long l = this.count;
            Long l2 = this.count = Long.valueOf(this.count + 1L);
            this.computeTimespan();
            Point from = (Point)this.getPreviousGeoEvent().getGeometry().getGeometry();
            Point to = (Point)this.getCurrentGeoEvent().getGeometry().getGeometry();
            this.distance = MotionCalculator.lawOfCosineDistance(from.getX(), from.getY(), to.getX(), to.getY());
            this.height = to.getZ() - from.getZ();
            if (this.distance == 0.0) {
                this.distance = 1.0E-10;
            }
            this.slope = this.height / (this.distance * 1000.0);
            if (MotionCalculator.this.distanceUnit.compareTo("Miles") == 0) {
                motionElements = this;
                motionElements.distance = motionElements.distance * 0.621371;
                this.slope = this.height / (this.distance * 5280.0);
            } else if (MotionCalculator.this.distanceUnit.compareTo("Nautical Miles") == 0) {
                motionElements = this;
                motionElements.distance = motionElements.distance * 0.539957;
                this.slope = this.height / (this.distance * 6076.12);
            }
            Double timespanHours = this.timespanSeconds / 3600.0;
            Double newSpeed = this.distance / timespanHours;
            this.acceleration = (newSpeed - this.speed) / timespanHours;
            this.speed = newSpeed;
            if (this.minDistance > this.distance) {
                this.minDistance = this.distance;
            }
            if (this.maxDistance < this.distance) {
                this.maxDistance = this.distance;
            }
            if (this.minHeight > this.height) {
                this.minHeight = this.height;
            }
            if (this.maxHeight < this.height) {
                this.maxHeight = this.height;
            }
            if (this.minSlope > this.slope) {
                this.minSlope = this.slope;
            }
            if (this.maxSlope < this.slope) {
                this.maxSlope = this.slope;
            }
            if (this.minSpeed > this.speed) {
                this.minSpeed = this.speed;
            }
            if (this.maxSpeed < this.speed) {
                this.maxSpeed = this.speed;
            }
            if (this.minAcceleration > this.acceleration) {
                this.minAcceleration = this.acceleration;
            }
            if (this.maxAcceleration < this.acceleration) {
                this.maxAcceleration = this.acceleration;
            }
            if (!Double.isNaN(this.distance)) {
                this.cumulativeDistance = this.cumulativeDistance + this.distance;
            }
            if (!Double.isNaN(this.height)) {
                this.cumulativeHeight = this.cumulativeHeight + this.height;
            }
            this.avgDistance = this.cumulativeDistance / (double)this.count.longValue();
            this.avgHeight = this.cumulativeHeight / (double)this.count.longValue();
            this.avgSpeed = this.avgDistance / this.avgTimespan;
            this.avgAcceleration = this.avgSpeed / this.avgTimespan;
            this.headingDegrees = MotionCalculator.heading(from.getX(), from.getY(), to.getX(), to.getY());
            Polyline polyline = new Polyline();
            polyline.startPath(from.getX(), from.getY());
            polyline.lineTo(to.getX(), to.getY());
            this.lineGeometry = polyline;
            this.sendReport();
        }

        private void sendReport() {
            if (MotionCalculator.this.notificationMode != MotionCalculatorNotificationMode.OnChange) {
                return;
            }
            LOGGER.debug("sendReport");
            try {
                GeoEvent outGeoEvent = this.createMotionGeoEvent();
                if (outGeoEvent == null) {
                    LOGGER.debug("outGeoEvent is null");
                    return;
                }
                LOGGER.debug(outGeoEvent.toString());
                MotionCalculator.this.send(outGeoEvent);
            }
            catch (MessagingException e) {
                LOGGER.error("Error sending update GeoEvent for " + this.id, (Throwable)e);
            }
        }

        private GeoEvent createMotionGeoEvent() {
            GeoEvent geoEventOut = null;
            try {
                GeoEventDefinition edOut = MotionCalculator.this.lookupAndCreateEnrichedDefinition(this.currentGeoEvent.getGeoEventDefinition());
                if (edOut == null) {
                    LOGGER.debug("edOut is null");
                    return null;
                }
                geoEventOut = MotionCalculator.this.geoEventCreator.create(edOut.getGuid(), new Object[]{this.getCurrentGeoEvent().getAllFields(), MotionCalculator.this.createMotionGeoEventFields(this.currentGeoEvent.getTrackId(), this)});
                if (MotionCalculator.this.geometryType.equals("Line")) {
                    geoEventOut.setGeometry(new MapGeometry(this.lineGeometry, SpatialReference.create((int)4326)));
                }
                geoEventOut.setProperty(GeoEventPropertyName.TYPE, (Object)"event");
                geoEventOut.setProperty(GeoEventPropertyName.OWNER_ID, (Object)MotionCalculator.this.getId());
                geoEventOut.setProperty(GeoEventPropertyName.OWNER_URI, (Object)MotionCalculator.this.definition.getUri());
                for (Map.Entry property : this.getCurrentGeoEvent().getProperties()) {
                    if (geoEventOut.hasProperty((GeoEventPropertyName)property.getKey())) continue;
                    geoEventOut.setProperty((GeoEventPropertyName)property.getKey(), property.getValue());
                }
            }
            catch (Exception error) {
                LOGGER.error("CREATE_GEOEVENT_FAILED", new Object[]{error.getMessage()});
                LOGGER.info(error.getMessage(), (Throwable)error);
            }
            return geoEventOut;
        }

        public Date getTimestamp() {
            return this.getCurrentGeoEvent().getStartTime();
        }

        public Double getDistance() {
            return this.distance;
        }

        public Double getTimespanSeconds() {
            return this.timespanSeconds;
        }

        public Double getSpeed() {
            return this.speed;
        }

        public Double getHeadingDegrees() {
            return this.headingDegrees;
        }

        public Double getMinDistance() {
            return this.minDistance;
        }

        public Double getMaxDistance() {
            return this.maxDistance;
        }

        public Double getAvgDistance() {
            return this.avgDistance;
        }

        public Double getMinSpeed() {
            return this.minSpeed;
        }

        public Double getMaxSpeed() {
            return this.maxSpeed;
        }

        public Double getAvgSpeed() {
            return this.avgSpeed;
        }

        public Double getMinTime() {
            return this.minTimespan;
        }

        public Double getAvgTime() {
            return this.avgTimespan;
        }

        public Double getMaxTime() {
            return this.maxTimespan;
        }

        public Double getMinAcceleration() {
            return this.minAcceleration;
        }

        public Double getAvgAcceleration() {
            return this.avgAcceleration;
        }

        public Double getMaxAcceleration() {
            return this.maxAcceleration;
        }

        public Double getAcceleration() {
            return this.acceleration;
        }

        public Date getPredictiveTime() {
            Long timespan = this.getCurrentGeoEvent().getStartTime().getTime() + (long)(MotionCalculator.this.predictiveTimespan * 1000);
            Date pt = new Date();
            pt.setTime(timespan);
            this.predictiveTime = pt;
            return this.predictiveTime;
        }

        public MapGeometry getPredictiveGeometry() {
            Double R = 6356.7523142;
            double earthRadius = R;
            double predictiveDistance = this.speed * ((double)MotionCalculator.this.predictiveTimespan.intValue() / 3600.0);
            if ("miles".equalsIgnoreCase(MotionCalculator.this.distanceUnit)) {
                predictiveDistance *= 0.621371;
                earthRadius *= 0.621371;
            }
            if ("nautical miles".equalsIgnoreCase(MotionCalculator.this.distanceUnit)) {
                predictiveDistance *= 0.539957;
                earthRadius *= 0.539957;
            }
            if (MotionCalculator.this.notificationMode == MotionCalculatorNotificationMode.Continuous) {
                LOGGER.debug("continuous prediction");
                Date currentDate = new Date();
                double timespanToCurrentTime = (double)(currentDate.getTime() - this.getCurrentGeoEvent().getStartTime().getTime()) / 1000.0;
                predictiveDistance = this.speed * (timespanToCurrentTime / 3600.0);
            }
            double distRatio = predictiveDistance / earthRadius;
            double distRatioSine = Math.sin(distRatio);
            double distRatioCosine = Math.cos(distRatio);
            Point currentPoint = (Point)this.getCurrentGeoEvent().getGeometry().getGeometry();
            double startLonRad = MotionCalculator.toRadians(currentPoint.getX());
            double startLatRad = MotionCalculator.toRadians(currentPoint.getY());
            double startLatCos = Math.cos(startLatRad);
            double startLatSin = Math.sin(startLatRad);
            double endLatRads = Math.asin(startLatSin * distRatioCosine + startLatCos * distRatioSine * Math.cos(MotionCalculator.toRadians(this.headingDegrees)));
            double endLonRads = startLonRad + Math.atan2(Math.sin(MotionCalculator.toRadians(this.headingDegrees)) * distRatioSine * startLatCos, distRatioCosine - startLatSin * Math.sin(endLatRads));
            double newLat = MotionCalculator.toDegrees(endLatRads);
            double newLong = MotionCalculator.toDegrees(endLonRads);
            if ("point".equalsIgnoreCase(MotionCalculator.this.predictiveGeometryType)) {
                Point point = new Point(newLong, newLat, currentPoint.getZ());
                return new MapGeometry((Geometry)point, SpatialReference.create((int)4326));
            }
            Polyline polyline = new Polyline();
            polyline.startPath(new Point(currentPoint.getX(), currentPoint.getY(), currentPoint.getZ()));
            polyline.lineTo(new Point(newLong, newLat, currentPoint.getZ()));
            return new MapGeometry((Geometry)polyline, SpatialReference.create((int)4326));
        }

        public GeoEvent getPreviousGeoEvent() {
            return this.previousGeoEvent;
        }

        public GeoEvent getCurrentGeoEvent() {
            return this.currentGeoEvent;
        }

        public Double getSlope() {
            return this.slope;
        }

        public void setSlope(Double slope) {
            this.slope = slope;
        }

        public Double getMinSlope() {
            return this.minSlope;
        }

        public void setMinSlope(Double minSlope) {
            this.minSlope = minSlope;
        }

        public Double getMaxSlope() {
            return this.maxSlope;
        }

        public void setMaxSlope(Double maxSlope) {
            this.maxSlope = maxSlope;
        }

        public Double getAvgSlope() {
            return this.avgSlope;
        }

        public void setAvgSlope(Double avgSlope) {
            this.avgSlope = avgSlope;
        }

        public Double getHeight() {
            return this.height;
        }

        public Double getMinHeight() {
            return this.minHeight;
        }

        public Double getAvgHeight() {
            return this.avgHeight;
        }

        public Double getMaxHeight() {
            return this.maxHeight;
        }
    }
}

